//
//  Point.cpp
//
//  Definition of Point class
//  Managing 2D points
//  Demonstrating overloaded +, <<, and >> operators
//
//  D.H. House, Nov. 8, 2019
//  CPSC 1070, Clemson University
//

#include "Point.h"

using namespace std;

Point::Point(): x(0), y(0){
}

Point::Point(float x0, float y0): x(x0), y(y0){
}

Point::Point(const Point &pt): x(pt.x), y(pt.y){
}

void Point::set(float x0, float y0){
  x = x0;
  y = y0;
}

void Point::set(const Point &pt){
  x = pt.x;
  y = pt.y;
}

float Point::getx() const{
  return x;
}

float Point::gety() const{
  return y;
}

Point Point::operator+(const Point &dp){
  Point movedpoint;
  
  movedpoint.x = x + dp.x;
  movedpoint.y = y + dp.y;
  
  return movedpoint;
}

ostream& operator<<(ostream &os, const Point &pt){
  os << "(" << pt.x << ", " << pt.y << ")";
  return os;
}

istream& operator>>(istream &is, Point &pt){
  is >> pt.x >> pt.y;
  return is;
}
