//
//  Point.h
//
//  Declaration of Point class
//  Managing 2D points
//  Demonstrating overloaded +, <<, and >> operators
//
//  D.H. House, Nov. 8, 2019
//  CPSC 1070, Clemson University
//

#include <iostream>

class Point{
private:
  float x, y;

public:
  Point();
  Point(float x0, float y0);
  Point(const Point &pt);
  
  void set(float x0, float y0);
  void set(const Point &pt);

  float getx() const;
  float gety() const;
  
  Point operator+(const Point &dp);

  friend std::ostream& operator<<(std::ostream &os, const Point &pt);
  friend std::istream& operator>>(std::istream &is, Point &pt);
};
