//
//  Rectangle.cpp
//
//  Definition of Rectangle class
//  Demonstrating overloaded constructors, and set method,
//  and overloaded +, <<, and >> operators
//
//  D.H. House, Nov. 8, 2019
//  CPSC 1070, Clemson University
//

#include <iostream>
#include <cmath>
#include "Rectangle.h"

using namespace std;

Rectangle::Rectangle(): width(0), height(0){
}

Rectangle::Rectangle(const Point &p0, float w, float h): x0(p0), width(w), height(h){
}

Rectangle::Rectangle(const Point &pll, const Point &pur){
  set(pll, pur);
}

Rectangle::Rectangle(const Rectangle &rect){
  x0 = rect.x0;
  width = rect.width;
  height = rect.height;
}

void Rectangle::set(const Point &p0, float w, float h){
  x0 = p0;
  width = w;
  height = h;
}

void Rectangle::set(const Point &pll, const Point &pur){
  float xmin = (pll.getx() < pur.getx())? pll.getx() : pur.getx();
  float ymin = (pll.gety() < pur.gety())? pll.gety() : pur.gety();
  float xmax = (pll.getx() > pur.getx())? pll.getx() : pur.getx();
  float ymax = (pll.gety() > pur.gety())? pll.gety() : pur.gety();
  
  x0.set(xmin, ymin);
  width = xmax - xmin;
  height = ymax - ymin;
}

Point Rectangle::getx0() const{
  return x0;
}

float Rectangle::getwidth() const{
  return width;
}

float Rectangle::getheight() const{
  return height;
}

float Rectangle::area() const{
  return width * height;
}

Rectangle Rectangle::operator+(const Point &dx){
  Rectangle newrect;
  
  newrect.x0 = x0 + dx;
  newrect.width = width;
  newrect.height = height;
  
  return newrect;
}

ostream& operator<<(ostream &os, const Rectangle &r){
  os << "[" << r.x0 << ", " << r.width << ", " << r.height << "]";
  return os;
}

istream& operator>>(istream &is, Rectangle &r){
  is >> r.x0 >> r.width >> r.height;
  return is;
}

