//
//  tryrectops.cpp
//
//  Program that exercises the Rectangle class with overloaded constructors,
//  and overloaded +, <<, and >> operators
//
//  D.H. House, Nov. 5, 2019
//  CPSC 1070 Clemson University
//
//  usage: tryrectops
//

#include <iostream>
#include "Rectangle.h"

using namespace std;

//
// Print out a rectangle and its area
//
void printrectinfo(const Rectangle &r){
  cout << "Rectangle: " << r << endl;
  cout << "Area: " << r.area() << endl;
  cout << endl;
}

//
// Create and print 3 Rectangles using the two initializing constructors
// and the copy constructor. All I/O is done using overloaded << and >>
// operators on Point and Rectangle
//
int main(){
  float x, y;
  
  Point pll;
  cout << "Enter pll: ";
  cin >> pll;
  
  Point pur;
  cout << "Enter pur: ";
  cin >> pur;

  cout << "Corner points: " << pll << ", " << pur << endl;
  
  Rectangle rect1(pll, pur);
  printrectinfo(rect1);
  
  Rectangle rect2;
  cout << "Enter x0, width and height: ";
  cin >> rect2;
  
  printrectinfo(rect2);

  Point delta(20, 30);
  rect2 = rect2 + delta;
  cout << "Copy of rectangle moved by " << delta << endl;

  Rectangle rect3(rect2);
  printrectinfo(rect3);

  return 0;
}
