//
//  Rectangle.h
//
//  Definition of Rectangle class
//  Demonstrating overloaded constructor and set method
//
//  D.H. House, Nov. 5, 2019
//  CPSC 1070, Clemson University
//

#include <iostream>
#include "Rectangle.h"

using namespace std;

Rectangle::Rectangle(): width(0), height(0){
}

Rectangle::Rectangle(const Point &p0, float w, float h): x0(p0), width(w), height(h){
}

Rectangle::Rectangle(const Point &pll, const Point &pur): x0(pll), width(pur.x - pll.x), height(pur.y - pll.y){
}

Rectangle::Rectangle(const Rectangle &rect): x0(rect.x0), width(rect.width), height(rect.height){
}

void Rectangle::set(const Point &p0, float w, float h){
  x0 = p0;
  width = w;
  height = h;
}

void Rectangle::set(const Point &pll, const Point &pur){
  x0 = pll;
  width = pur.x - pll.x;
  height = pur.y - pll.y;
}

Point Rectangle::getx0() const{
  return x0;
}

float Rectangle::getwidth() const{
  return width;
}

float Rectangle::getheight() const{
  return height;
}

float Rectangle::area() const{
  return width * height;
}

void Rectangle::move(float dx, float dy){
  x0.x += dx;
  x0.y += dy;
}

void Rectangle::print() const{
  cout << "[";
  x0.print();
  cout << ", " << width << ", " << height << "]";
}

