//
//  Rectangle.h
//
//  Declaration of Rectangle class
//  Demonstrating overloaded constructor and set method
//
//  D.H. House, Nov. 5, 2019
//  CPSC 1070, Clemson University
//
#include "Point.h"

class Rectangle{
private:
  Point x0;
  float width, height;
  
public:
  Rectangle();
  Rectangle(const Point &p0, float w, float h);
  Rectangle(const Point &pll, const Point &pur);
  Rectangle(const Rectangle &rect);

  void set(const Point &p0, float w, float h);
  void set(const Point &pll, const Point &pur);
  
  Point getx0() const;
  float getwidth() const;
  float getheight() const;
  
  float area() const;

  void move(float dx, float dy);

  void print() const;
};
