//
//  tryrect.cpp
//
//  Program that exercises the Rectangle class
//  D.H. House, Nov. 5, 2019
//  CPSC 1070 Clemson University
//
//  usage: tryrect
//

#include <iostream>
#include "Rectangle.h"

using namespace std;

//
// Print out a rectangle and its area
//
void printrectinfo(const Rectangle &r){
  cout << "Rectangle: ";
  r.print();
  cout << endl;
  
  cout << "Area: " << r.area() << endl;
  cout << endl;
}

//
// Create and print 3 Rectangles using the two initializing constructors
// and the copy constructor
//
int main(){
  float x, y;
  
  cout << "Enter pll: ";
  cin >> x >> y;
  Point pll(x, y);
  
  cout << "Enter pur: ";
  cin >> x >> y;
  Point pur(x, y);

  cout << "Corner points: ";
  pll.print();
  cout << ", ";
  pur.print();
  cout << endl;
  
  Rectangle rect1(pll, pur);
  
  printrectinfo(rect1);
  
  cout << "Enter x0: ";
  cin >> x >> y;
  Point x0(x, y);
  
  float w, h;
  cout << "Enter width and height: ";
  cin >> w >> h;

  cout << "Corner and dimensions: ";
  x0.print();
  cout << ", " << w << ", " << h << endl;
  
  Rectangle rect2(x0, w, h);
  printrectinfo(rect2);

  rect2.move(20, 20);
  cout << "Copy of rectangle moved by (20, 20)" << endl;

  Rectangle rect3(rect2);
  printrectinfo(rect3);

  return 0;
}
