//
//  trytri.cpp
//
//  Program that demonstrates overloaded triangle area calculations
//  D.H. House, Nov. 5, 2019
//  CPSC 1070 Clemson University
//
//  usage: tryrect
//

#include <iostream>
#include <cmath>
#include "Point.h"

using namespace std;

// area = 1/2 base * height
float triarea(float b, float h){
  return 0.5 * b * h;
}

// area computed using the perimeter of the triangle via Heron's formula
float triarea(float a, float b, float c){
  float s = 0.5 * (a + b + c);
  return sqrt(s * (s - a) * (s - b) * (s - c));
}

// area = 1/2 magnitude of cross product of 2 edges
float triarea(const Point &p0, const Point &p1, const Point &p2){
  float ax = p1.x - p0.x;
  float ay = p1.y - p0.y;
  float bx = p2.x - p0.x;
  float by = p2.y - p0.y;
  
  return 0.5 * fabs(ax * by - ay * bx);
}

//
// Input parameters for the vertices of a triangle and use these
// to calculate each triangle's area using 3 overloaded functions
//
int main(){
  float x0, x1;
  float x2, y2;
  
  cout << "Enter x0 and x1: ";
  cin >> x0 >> x1;
  Point p0(x0, 0);
  Point p1(x1, 0);

  cout << "Enter p2: ";
  cin >> x2 >> y2;
  Point p2(x2, y2);
  
  cout << "Triangle vertices: ";
  p0.print();
  cout << ", ";
  p1.print();
  cout << ", ";
  p2.print();
  cout << endl;
  cout << "Area: " << triarea(p0, p1, p2) << endl;
  cout << endl;
  
  float base = p1.x - p0.x;
  float height = p2.y - p0.y;
  cout << "Triangle base and height: " << base << ", " << height << endl;
  cout << "Area: " << triarea(base, height) << endl;
  cout << endl;
  
  float a = base;
  float b = sqrt((p2.x - p0.x) * (p2.x - p0.x) + (p2.y - p0.y) * (p2.y - p0.y));
  float c = sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y));
  cout << "Triangle sides: " << a << ", " << b << ", " << c << endl;
  cout << "Area: " << triarea(a, b, c) << endl;

  return 0;
}
