//
//  additiontable.cpp
//  
//  Definition of the additiontable class
//
//  Created by Donald House on 10/27/19.
//

#include "additiontable.h"
#include <cstdlib>
#include <iostream>
#include <fstream>

using namespace std;

additiontable::additiontable(int maxnum): maxnumber(0), table(NULL){
  setmaxnumber(maxnum);
}

additiontable::additiontable(const additiontable &addtable){
  setmaxnumber(addtable.maxnumber);
  
  for(int i = 0; i < maxnumber * maxnumber; i++)
    table[i] = addtable.table[i];
}

additiontable::~additiontable(){
  delete []table;
}

void additiontable::setmaxnumber(int maxnum){
  if(maxnum <= 0){
    cerr << "Maximum number must be an integer > 0" << endl;
    exit(2);
  }

  if(maxnum != maxnumber){
    delete []table;
    table = new entry[maxnumber * maxnumber];
  }
  
  maxnumber = maxnum;
}

int additiontable::getmaxnumber() const{
  return maxnumber;
}

void additiontable::buildtable(){
  for(int i = 0; i < maxnumber; i++){
    for(int j = 0; j < maxnumber; j++){
      table[i * maxnumber + j].m = i + 1;
      table[i * maxnumber + j].n = j + 1;
      table[i * maxnumber + j].sum = i + j + 2;
    }
  }
}

entry *additiontable::gettable() const{
  return table;
}

void additiontable::savetable(const char *filename) const{
  ofstream outfile;
  outfile.open(filename);
  if(!outfile.is_open()){
    cerr << "unable to open output file: " << filename << endl;
    exit(3);
  }
  
  for(int i = 0; i < maxnumber; i++){
    for(int j = 0; j < maxnumber; j++){
      outfile << table[i * maxnumber + j].m << " + ";
      outfile << table[i * maxnumber + j].n << " = ";
      outfile << table[i * maxnumber + j].sum << endl;
    }
    outfile << endl;
  }
  
  outfile.close();
}
