/*
   queue.h

   Definitions of functions for maintaining
   a queue using an array-based approach
  
   D.H. House, Oct. 1, 2019
   CPSC 1070, Clemson University
*/

#include <stdio.h>
#include <stdlib.h>
#include "queue.h"

void clear(Queue *q){
  q->head = q->tail = 0;
}

int empty(Queue *q){
  return q->head == q->tail;
}

void enter(int num, Queue *q){
  int i, j;
  
  if(q->tail == MAXQUEUEELEMENTS){
    for(i = 0, j = q->head; j < q->tail; i++, j++)
      q[i] = q[j];
    q->head = 0;
    q->tail = i;
    if(q->tail == MAXQUEUEELEMENTS){
      fprintf(stderr, "queue overflow\n");
      exit(1);
    }
  }
  
  q->entries[q->tail] = num;
  q->tail++;
}

int leave(Queue *q){
  int n;
  
  if(empty(q)){
    fprintf(stderr, "queue underflow\n");
    exit(2);
  }

  n = q->entries[q->head];
  q->head++;
  return n;
}
