/*
  Definitions of functions for maintaining
  a stack using an array-based approach
 
  D.H. House, Oct. 1, 2019
  CPSC 1070, Clemson University
*/

#include <stdio.h>
#include <stdlib.h>
#include "stack.h"

void clear(Stack *s){
  s->top = 0;
}

int empty(Stack *s){
  return s->top == 0;
}

void push(int num, Stack *s){
  if(s->top == MAXSTACKELEMENTS){
    fprintf(stderr, "stack overflow\n");
    exit(1);
  }
  
  s->entries[s->top] = num;
  s->top++;
}

int pop(Stack *s){
  if(empty(s)){
    fprintf(stderr, "stack underflow\n");
    exit(2);
  }
  
  int n = s->entries[--(s->top)];

  return n;
}
