//
//  betterpal.c
//  recursive implementation of palindrome test
//  also showing string processing and command line argument
//
//  Donald House 9/10/19.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

typedef enum _bool{FALSE, TRUE} bool;

// recursive palindrome test given start and end index of substring to test
bool rpalindrome(const char str[], int start, int end){
  if(end - start <= 0)
    return TRUE;
  else if(str[start] != str[end])
    return FALSE;
  else
    return rpalindrome(str, start + 1, end - 1);
}

// First convert all characters to lower case and strip out any punctuation or spaces
// Then, use the recursive palindrome test, supplying start and end string indices
bool ispalindrome(const char str[]){
  char *cleanstr;
  int i, j;
  char ch;
  bool ispal;
  
  cleanstr = (char *)malloc((strlen(str) + 1) * sizeof(char));
  
  for(i = 0, j = 0; i < strlen(str); i++){
    ch = str[i];
    if(ch >= 'A' && ch <= 'Z')
      ch = ch - 'A' + 'a';
    if(ch >= 'a' && ch <= 'z')
      cleanstr[j++] = ch;
  }
  cleanstr[j] = '\0';

  ispal = rpalindrome(cleanstr, 0, strlen(cleanstr) - 1);
  
  free(cleanstr);
  
  return ispal;
}

// program takes one command line argument, which is the string to test
int main(int argc, char *argv[]){
  if(argc != 2){
    printf("usage: betterpal <string>\n");
    exit(1);
  }
  
  if(ispalindrome(argv[1]))
    printf("%s is a palindrome\n", argv[1]);
  else
    printf("%s is not a palindrome\n", argv[1]);

  return 0;
}
