//
//  bubblesort.cpp
//
//  Example bubble sort written in C++
//  CPSC 1070, Fall 2019
//
//  Integer numbers are read from the command line
//  and printed in sorted order.
//
//  Created by Donald House on 10/13/2019.
//  Copyright 2019 Clemson University. All rights reserved.
//

#include <iostream>     // needed for stream I/O
using namespace std;    // needed so that Stream I/O names recognized

// swap contents of num1 and num2
void swap(int &num1, int &num2){
  int temp;
  temp = num1;
  num1 = num2;
  num2 = temp;
}

int main(){
  int *numbers;       // will point to the array of numbers
  int n;              // the number of numbers in the array
  int i, j;           // for loop indices
  
  // read how many numbers will be input
  cout << "enter number of numbers: ";
  cin >> n;
  
  // allocate an array of n ints
  numbers = new int[n];
  
  // Read data from the user
  printf("enter the numbers: ");
  for(i = 0; i < n; i++)
    cin >> numbers[i];
  
  // bubble sort the numbers into ascending order
  for(i = n - 1; i > 0; i--)
    for(j = 0; j < i; j++)
      if(numbers[j] > numbers[j + 1])
        swap(numbers[j], numbers[j + 1]);
  
  // print the numbers out on one line, comma separated
  for(i = 0; i < n - 1; i++)
    cout << numbers[i] << ", ";
  cout << numbers[i] << endl;
  
  return 0;
}
