//
//  bettercalc.c
//  A simple calculator
//  An example of command line argument processing.
//  This version uses sscanf() to convert strings into numbers
//  allowing it to do better error checking, and in addition, makes
//  sure that all characters of numeric arguments are valid characters
//
//  Donald House 9/17/19.
//
#include <stdio.h>
#include <stdlib.h>       // the standard library has the atof() function
#include <string.h>
#include <ctype.h>

typedef enum _bool{FALSE, TRUE} bool;

bool validfloat(char *numstr){
  int numdigits = 0;
  int numpoints = 0;
  int i = 0;
  
  if(numstr[0] == '-' || numstr[0] == '+')
    i = 1;
  
  for(; i < strlen(numstr) && (isdigit(numstr[i]) || numstr[i] == '.'); i++)
    if(isdigit(numstr[i]))
      numdigits++;
    else
      numpoints++;
  
  if(i < strlen(numstr) || numdigits == 0 || numpoints > 1)
    return FALSE;
  else
    return TRUE;
}

//
// program takes three command line arguments,
// in the format <number> <op> <number>, where <op> is one of +, -, *, /
//
int main(int argc, char *argv[]){
  float num1, num2;
  float result;
  char op;
  
  // when using command line arguments, always check that the number of arguments
  // is reasonable. If not, print a usage message and quit with an error status code
  if(argc != 4){
    printf("usage: bettercalc <number> [+|-|x|/] <number>\n");
    return 1;
  }
  
  // converts the first arg to floating point
  if(!validfloat(argv[1]) || sscanf(argv[1], "%f", &num1) != 1){
    printf("%s is not a valid floating point number\n", argv[1]);
    return 1;
  }
  
  op = argv[2][0];        // the first character of the 2nd arg should be the operator
  
  // converts the 3rd arg to floating point
  if(!validfloat(argv[3]) || sscanf(argv[3], "%f", &num2) != 1){
    printf("%s is not a valid floating point number\n", argv[3]);
    return 3;
  }

  // do the calculation based on the operator input
  // signal an error and quit if the operator is invalid
  switch(op){
    case '+':
      result = num1 + num2;
      break;
      
    case '-':
      result = num1 - num2;
      break;
      
    case 'x':
      result = num1 * num2;
      break;
      
    case '/':
      result = num1 / num2;
      break;
      
    default:
      printf("%c is not a valid operator, only +, -, x, / permitted\n", op);
      return 2;
  }
  
  // tell the user the result of the calculation
  printf("%f %c %f = %f\n", num1, op, num2, result);

  return 0;
}
