//
//  calculator.c
//  A simple calculator
//  An example of command line argument processing
//  This version uses atof() to convert strings into numbers
//
//  Donald House 9/17/19.
//
#include <stdio.h>
#include <stdlib.h>       // the standard library has the atof() function

typedef enum _bool{FALSE, TRUE} bool;

//
// program takes three command line arguments,
// in the format <number> <op> <number>, where <op> is one of +, -, *, /
//
int main(int argc, char *argv[]){
  float num1, num2;
  float result;
  char op;
  
  // when using command line arguments, always check that the number of arguments
  // is reasonable. If not, print a usage message and quit with an error status code
  if(argc != 4){
    printf("usage: calculator <number> [+|-|x|/] <number>\n");
    return 1;
  }
  
  num1 = atof(argv[1]);   // converts the first argument string to a floating point number
  op = argv[2][0];        // the first character of the 2nd argument should be the operator
  num2 = atof(argv[3]);   // converts the second argument string to a floating point number
  
  // do the calculation based on the operator input
  // signal an error and quit if the operator is invalid
  switch(op){
    case '+':
      result = num1 + num2;
      break;
      
    case '-':
      result = num1 - num2;
      break;
      
    case 'x':
      result = num1 * num2;
      break;
      
    case '/':
      result = num1 / num2;
      break;
      
    default:
      printf("%c is not a valid operator, only +, -, x, / permitted\n", op);
      return 2;
  }
  
  // tell the user the result of the calculation
  printf("%f %c %f = %f\n", num1, op, num2, result);

  return 0;
}
