//
//  Point.cpp
//
//  Definition of Point class
//  Managing 2D points
//
//  This version makes use of default parameters to merge the default
//  and initializing constructors, and uses an initializer list.
//  It also recognizes constant methods
//
//  D.H. House, Oct. 15, 2019
//  CPSC 1070, Clemson University
//

#include <iostream>
#include "Point.h"

using namespace std;

// constructor uses an initialization list
Point::Point(int x0, int y0): x(x0), y(y0){
}

void Point::set(int x0, int y0){
  x = x0;
  y = y0;
}

int Point::getx() const{
  return x;
}

int Point::gety() const{
  return y;
}

void Point::move(int dx, int dy){
  x += dx;
  y += dy;
}

void Point::print() const{
  cout << "(" << x << ", " << y << ")";
}

