//
//  Point.h
//
//  Definition of Point class
//  Managing 2D points
//
//  This version makes use of default parameters to merge the default
//  and initializing constructors, and uses an initializer list.
//  It also recognizes constant methods
//
//  D.H. House, Oct. 15, 2019
//  CPSC 1070, Clemson University
//

class Point{
private:
  int x, y;

public:
  // combined default and initializing constructor
  Point(int x0 = 0, int y0 = 0);
  
  void set(int x0, int y0);
  
  // neither getx() nor gety() modifies the object
  int getx() const;
  int gety() const;

  void move(int dx, int dy);

  // print() does not modify the object
  void print() const;
};
