//
// Polygon.cpp
//
// Definition of Polygon class
// Maintaining a polygon using the Point class for vertices
//
// D.H. House, Oct. 15, 2019//
// CPSC 1070, Clemson University
//

#include "Polygon.h"
#include <iostream>
using namespace std;

int Polygon::numpolygons = 0;

// Default constructor makes sure number of vertices is 0
// and that vertices pointer is NULL
// Constructor also increments the count numpolygons.
Polygon::Polygon(): vertices(NULL), nverts(0){
  numpolygons++;
}

// Copy constructor, copy the vertex array from Polygon poly
// to the new Polygon being constructed.
// Constructor also increments the count numpolygons.
Polygon::Polygon(const Polygon &poly){
  nverts = poly.nverts;
  vertices = new Point[nverts];

  for(int i = 0; i < nverts; i++)
    vertices[i] = poly.vertices[i];

  numpolygons++;
}

// Destructor, delete the array of vertices
Polygon::~Polygon(){
  delete []vertices;

  numpolygons--;
}

int Polygon::getnumpolygons() const{
  return numpolygons;
}

void Polygon::addvertex(const Point &pt){
  Point *oldverts = vertices;
  
  vertices = new Point[++nverts];
  
  for(int i = 0; i < nverts - 1; i++)
    vertices[i] = oldverts[i];
  
  vertices[nverts - 1] = pt;
  
  delete []oldverts;
}

int Polygon::getnverts() const{
  return nverts;
}

Point *Polygon::getvertices() const{
  Point *vtxcopy = new Point[nverts];
  
  for(int i = 0; i < nverts; i++)
    vtxcopy[i] = vertices[i];
  
  return vtxcopy;
}

void Polygon::setvertices(int n, Point *verts){
  if(n != nverts){
    delete []vertices;
    nverts = n;
    vertices = new Point[nverts];
  }

  for(int i = 0; i < nverts; i++)
    vertices[i] = verts[i];
}

void Polygon::print() const{
  for(int i = 0; i < nverts - 1; i++){
    vertices[i].print();
    cout << ", ";
  }
  vertices[nverts - 1].print();
  cout << endl;
}

