//
//  Polygon.h
//
//  Declaration of Polygon class
//  Maintaining a polygon using the Point class for vertices
//
//  D.H. House, Oct. 15, 2019
//  CPSC 1070, Clemson University
//

// Polygon depends upon Point, so needs to include Point.h
#include "Point.h"

class Polygon{
private:
  static int numpolygons;   // global total number of polygons
  
  Point *vertices;          // vertex array for polygon
  int nverts;               // number of polygon vertices

public:
  Polygon();
  Polygon(const Polygon &poly);
  
  // A destructor is needed since Polygon allocates space
  // for the vertices array. It needs to be freed up.
  // Also the destructor needs to decrement the count in numpolygons
  ~Polygon();
  
  int getnumpolygons() const;
  
  void addvertex(const Point &pt);
  
  int getnverts() const;
  Point *getvertices() const;
  
  void setvertices(int n, Point *verts);
  
  void print() const;
};
