//
// trypolygon.cpp
//
// Program that exercises the Polygon class
// D.H. House, Oct. 15, 2019
// CPSC 1070 Clemson University
//
// usage: trypolygon
//

#include <iostream>
#include "Polygon.h"

using namespace std;

//
// Read in pairs of integer numbers
// Each pair of numbers constitutes the coordinates of a single vertex.
// Stop when ^D is input
// Print out the Polygon formed from these vertices.
// Then get the number of vertices and the vertices from this Polygon and
// initialize another Polygon with the same vertices
// Finally, use the copy constructor to create a new Polygon, again with the
// same vertices.
//
int main(int argc, char *argv[]){
  Polygon poly1;
  Point pt;
  int nx, ny;

  // read in the initial vertices and add to polygon one by one
  cout << "Enter poly1 vertices: ";
  cin >> nx >> ny;
  while(!cin.eof()){
    pt.set(nx, ny);
    poly1.addvertex(pt);
    cin >> nx >> ny;
  }
  poly1.print();
  cout << endl;
  cout << "currently there are " << poly1.getnumpolygons() << " polygons" << endl;
  
  // get the number of vertices, and the vertices from the polygon
  // and and print them out
  int n = poly1.getnverts();
  Point *pts = poly1.getvertices();
  cout << "poly1 has " << n << " vertices" << endl;
  cout << "they are: ";
  for(int i = 0; i < n - 1; i++){
    pts[i].print();
    cout << ", ";
  }
  pts[n - 1].print();
  cout << endl;
  
  // give another polygon the same vertices as the original polygon and print
  Polygon poly2;
  poly2.setvertices(n, pts);
  cout << "poly2 vertices are: ";
  poly2.print();
  cout << endl;

  // we are done with the copied vertices, so delete them
  delete []pts;
  
  // make a new polygon that is a copy of the first polygon using the
  // copy constructor
  Polygon *poly3 = new Polygon(poly1);
  cout << "poly3 vertices are: ";
  poly3->print();
  cout << endl;
  cout << "currently there are " << poly1.getnumpolygons() << " polygons" << endl;

  // now delete the new polygon
  cout << "deleting poly3" << endl;
  delete poly3;
  cout << "currently there are " << poly1.getnumpolygons() << " polygons" << endl;

  return 0;
}
