//
// Queue.cpp
//
// Array based C++ Queue class definition
//
// CPSC 1070 example program
// Donald H. House, 10/15/2019
//

#include "Queue.h"
#include <cstdlib>
#include <iostream>

using namespace std;

// constructor for Queue class
Queue::Queue(): head(0), tail(0){
}

// initialize the queue to empty
void Queue::clear(){
  head = tail = 0;
}

// return true if queue empty, false otherwise
bool Queue::empty() const{
  return (head == tail);
}

// insert a new value at the end of the queue
void Queue::enter(int newvalue){
  if(tail == MAXQENTRIES){
    cerr << "Queue overflow." << endl;
    exit(1);
  }
  
  values[tail++] = newvalue;
}

// remove the first entry in the queue and return its value
int Queue::leave(){
  if(empty()){
    cerr << "Queue underflow." << endl;
    exit(2);
  }
  
  return values[head++];
}


