//
// Queue.h
//
// Array based C++ Queue class declaration
//
// CPSC 1070 example program
// Donald H. House, 10/15/2019
//

#include <cstdlib>

#define MAXQENTRIES	  100

class Queue{
private:
  int values[MAXQENTRIES];
  int head, tail;			// indices of head and tail entries in queue

public:
  Queue();					// default constructor, start with empty queue
  
  void clear();        // initialize the queue to empty
  
  bool empty() const;  // returns true if queue empty, false otherwise

  void enter(int newvalue); // place a new value at the tail of the queue
  
  int leave();				// remove the head value from the queue
};
