//
// Stack.cpp
//
// Array based C++ stack class definition
// CPSC 1070 example program
// Donald H. House, 10/15/2019
//

#include "Stack.h"
#include <cstdlib>
#include <iostream>

using namespace std;

// constructor: start with stack empty
Stack::Stack(): top(0){
}

// initialize the stack to empty
void Stack::clear(){
  top = 0;
}

// return true if stack empty, false if not empty
bool Stack::empty() const{
  return top == 0;
}

// push a new value onto the top of the stack
void Stack::push(int newvalue){
  if(top < MAXSTACK)
    values[top++] = newvalue;
  else{
    cerr << "stack overflow" << endl;
    exit(1);
  }
}

// remove a value from the top of the stack and return it
int Stack::pop(){
  if(!empty())
    return values[--top];
  else{
    cerr << "stack underflow" << endl;
    exit(2);
  }
}
