//
// Queue.cpp
//
// list based C++ queue class definition
//
// CPSC 1070 example program
// Donald H. House, 10/15/2019//

#include "Queue.h"
#include <iostream>
#include <cstdlib>

using namespace std;

// constructor of entry container
entry::entry(int v, entry *ptr){
  value = v;
  next = ptr;
}

// constructor for Queue class
Queue::Queue(): head(NULL), tail(NULL){
  head = tail = NULL;    // make sure queue is empty
  n = 0;		  // nobody in queue yet
}

// destructor for Queue class
Queue::~Queue(){
  clear();
}

// initialize the queue to empty
void Queue::clear(){
  while(!empty())
    leave();
}

// return true if queue empty, false otherwise
bool Queue::empty() const{
  return head == NULL;
}

// insert a new value at the end of the queue
void Queue::enter(int newvalue){
  entry *newentry = new entry(newvalue, NULL);
  
  if(tail == NULL)
    head = newentry;
  else
    tail->next = newentry;
  
  tail = newentry;
  n++;
}

// remove the head entry in the queue and return its value
int Queue::leave(){
  if(empty()){
    cerr << "Queue underflow." << endl;
    exit(2);
  }
  
  int retvalue = head->value;
  entry *kill = head;
  
  head = head->next;
  if(head == NULL)
    tail = NULL;
  
  delete kill;
  
  n--;
  return retvalue;
}


