//
// Queue.h
//
// list based C++ Queue class declaration
//
// CPSC 1070 example program
// Donald H. House, 10/15/2019
//

#include <cstdlib>

// container to hold entries in the list supporting the queue
struct entry{
  int value;
  entry *next;
  
  entry(int v, entry *ptr);   // constructor sets value and next
};

class Queue{
private:
  entry *head, *tail;  // pointers to head and tail entry in queue
  int n;		// number of entries in the queue

public:
  Queue();		// default constructor, start with empty queue
  ~Queue();		// destructor, free space held by queue

  void clear();        // initialize the queue to empty
  bool empty() const;   // returns true if the queue is empty, false otherwise

  void enter(int newvalue);  // place a new value at the end of the queue
  int leave();				 // remove the head value in the queue
  
};
