//
// Stack.cpp
//
// List based C++ Stack class definition
// CPSC 1070 example program
// Donald H. House, 10/15/2019
//

#include "Stack.h"
#include <cstdlib>
#include <iostream>

using namespace std;

// constructor: start with stack empty
Stack::Stack(): top(NULL){
}

// destructor: delete all nodes on the stack when stack deleted
Stack::~Stack(){
  clear();
}

// initialize the stack to empty
void Stack::clear(){
  while(!empty())
    pop();
}

// return true if stack empty, false if not empty
bool Stack::empty() const{
  return top == NULL;
}

// push a new value onto the top of the stack
void Stack::push(int newvalue){
  Entry *newentry = new Entry;
  
  newentry->value = newvalue;
  newentry->next = top;
  
  top = newentry;
}

// remove a value from the top of the stack and return it
int Stack::pop(){
  Entry *topentry;
  int topvalue;
  
  if(!empty()){
    topentry = top;
    topvalue = topentry->value;
    
    top = topentry->next;
    delete topentry;
    
    return topvalue;
  }
  else{
    cerr << "stack underflow" << endl;
    exit(2);
  }
}

