//
// grid.c
//
// Read in a grid of floating point data from a file
// The first two entries in the file are integers giving the number of rows
// and columns in the grid. Subsequent numbers are the grid entries, in order
// by rows.
//
// Donald House
// 9/23/19
//
// CPSC 1070
// Clemson University
//
#include <stdio.h>
#include <stdlib.h>

// this function reads a file that must already be opened
// it builds a 2D array of floating point numbers and returns it to the calling program
float **loadgrid(FILE *infile, int *nrows, int *ncols){
  float **thegrid;
  int row, col;
  
  // get the number of rows and number of columns from the file and
  // pass them to the calling function
  if(fscanf(infile, "%d %d", nrows, ncols) != 2){
    fprintf(stderr, "missing row or column numbers in input file\n");
    exit(1);
  }
  
  // allocate an array of pointers that will point to the start of each row
  thegrid = (float **)malloc(*nrows * sizeof(float *));
  
  // allocate a block of memory the size of the grid, and point the first
  // element of the array of pointers to its beginning
  thegrid[0] = (float *)malloc(*nrows * *ncols * sizeof(float));
  
  // fill in the rest of the array of pointers, with each pointer advancing from
  // the previous one by the length of a row
  for(row = 1; row < *nrows; row++)
    thegrid[row] = thegrid[row - 1] + *ncols;
  
  // loop through the input file, filling in the array row by row
  for(row = 0; row < *nrows; row++){
    for(col = 0; col < *ncols; col++){
      if(fscanf(infile, "%f", &thegrid[row][col]) != 1){
        fprintf(stderr, "missing data for grid at row %d, col %d\n", row, col);
        exit(2);
      }
    }
  }
  
  // return the address of the constructed grid array
  return thegrid;
}

int main(int argc, char *argv[]){
  FILE *infile;
  
  int nrows, ncols;
  float **grid;

  int row, col;

  if(argc != 2){
    printf("usage: grid <filename>\n");
    return 1;
  }
  
  infile = fopen(argv[1], "r");
  if(infile == NULL){
    printf("cannot open input file %s\n", argv[1]);
    return 2;
  }
  
  grid = loadgrid(infile, &nrows, &ncols);
  
  for(row = 0; row < nrows; row++){
    for(col = 0; col < ncols - 1; col++){
      printf("%f, ", grid[row][col]);
    }
    printf("%f\n", grid[row][col]);
  }
    
  free(grid[0]);      // free the block of memory holding the grid data
  free(grid);         // free the array of pointers pointing to the rows of the grid
  
  fclose(infile);

  return 0;
}
