//
// Array class
// Array.cpp definition file
//
// Donald H. House  Nov. 21, 2019
// CPSC 1070 example code
// Clemson University
//

#include "Array.h"
using namespace std;

void Array::CheckBounds(int idx) const{
  if(idx < loidx || idx > hiidx){
    cerr << "array index: " << idx << " out of bounds: " << "(" << loidx << ", " << hiidx << ")" << endl;
    exit(11);
  }
}

Array::Array(int ilo, int ihi): loidx(0), hiidx(0), size(0), data(NULL){  // default + initialize constructors
  cout << "construct Array (" << ilo << ", " << ihi << ")" << endl;
  SetBounds(ilo, ihi);
}

Array::Array(const Array &a): loidx(a.loidx), hiidx(a.hiidx), size(0), data(NULL){          // copy constructor
  cout << "copy construct Array (" << loidx << ", " << hiidx << ")" << endl;
  SetBounds(loidx, hiidx);
  for(int i = 0; i < size; i++)
    data[i] = a.data[i];
}

Array::~Array(){
  cout << "delete Array (" << loidx << ", " << hiidx << ")" << endl;
  delete []data;
}

void Array::SetBounds(int ilo, int ihi){     // assign dimensions to Array
  if(ilo > ihi){
    cerr << "array bounds impossible: " << "[" << ilo << ", " << ihi << "]";
    exit(10);
  }
  
  if((ihi - ilo + 1) != size){
    delete []data;
    size = ihi - ilo + 1;
    data = new float[size];
  }
  
  for(int i = 0; i < size; i++)
    data[i] = 0.0;
  
  loidx = ilo;
  hiidx = ihi;
}

const Array &Array::operator=(const Array &a){
  if(this == &a)
    return *this;
  
  SetBounds(a.loidx, a.hiidx);
  for(int i = 0; i < size; i++)
    data[i] = a.data[i];
  
  return *this;
}

const float &Array::operator[](int idx) const{
  CheckBounds(idx);
  return data[idx - loidx];
}

float &Array::operator[](int idx){
  CheckBounds(idx);
  return data[idx - loidx];
}

// define << operator as friend function to Array
ostream& operator<<(std::ostream& os, const Array &a){
  os << "(" << a.loidx << ", " << a.hiidx << "):{";
  for(int i = 0; i < a.size - 1; i++)
    os << a.data[i] << ", ";
  os << a.data[a.size - 1] << "}";
  return os;
}
