//
// Array class
// Array.h header file
//
// Donald H. House  Nov. 21, 2019
// CPSC 1070 example code
// Clemson University
//

#include <iostream>

//
// Class of 1D floating point Array
//
class Array{
protected:
  int loidx, hiidx;		       // number of entries in Array
  int size;
  float *data;
  
  void CheckBounds(int idx) const;
  
public:
  Array(int ilow = 0, int ihi = 0);	  // default + initialize constructors
  Array(const Array &a);              // copy constructor

  virtual ~Array();                   // destructor, make sure array space deleted
  
  void SetBounds(int ilow, int ihi); // assign bounds of Array
  int Low() const {return loidx;}	   // accessor function for low bound
  int Hi() const {return hiidx;}     // accessor function for high bound

  const Array &operator=(const Array &a);
  
  const float &operator[](int idx) const;

  float &operator[](int idx);
  
  // define << operator as friend function to Array
  friend std::ostream& operator<<(std::ostream& out, const Array &a);
};


