//
// LabelArray class
// LabelArray.h
//
// Demonstration to show the use of class hierarchies in C++
//
// Donald H. House  Nov. 21, 2019
// CPSC 1070 example code
// Clemson University
//

#include <cstring>
#include "LabelArray.h"
using namespace std;

LabelArray::LabelArray(int ilo, int ihi, const char *initlabel): Array(ilo, ihi), label(NULL){
  cout << "construct LabelArray (" << ilo << ", " << ihi << "): ";
  if(initlabel == NULL)
    cout << "NULL" << endl;
  else
    cout << initlabel << endl;
  SetLabel(initlabel);
}

LabelArray::LabelArray(const LabelArray &la): Array((Array&)la), label(NULL){
  cout << "copy construct LabelArray (" << la.loidx << ", " << la.hiidx << "): ";
  SetLabel(la.label);
}

LabelArray::~LabelArray(){
  cout << "delete LabelArray (" << loidx << ", " << hiidx << "): " << label << endl;
  delete []label;
}

void LabelArray::SetLabel(const char *newlabel){
  delete label;		  // if old label, make sure its space is freed
  
  if(newlabel == NULL)
    label = NULL;
  else{
    label = new char[strlen(newlabel) + 1];
    strcpy(label, newlabel);
  }
}

const char *LabelArray::Label() const{
  return label;
}

const LabelArray &LabelArray::operator=(const LabelArray &a){
  if(this == &a)
    return *this;
  
  Array::operator=(a);

  SetLabel(a.label);
  return *this;
}

ostream& operator<<(ostream& os, const LabelArray &la){
  if(la.label == NULL)
    return (os << (Array&)la << " -- <no label>");
  else
    return (os << (Array&)la << " -- " << la.label);
}
