//
// LabelArray class
// LabelArray.h
//
// Demonstration to show the use of class hierarchies in C++
//
// Donald H. House  Nov. 21, 2019
// CPSC 1070 example code
// Clemson University
//

#include "Array.h"

//
// Subclass of 2D integer valued points with a text label
//
class LabelArray: public Array{
protected:
  char *label;				// text label for point
  
public:
  LabelArray(int ilo = 0, int ihi = 0, const char *initlabel = NULL);   // constuctor -- no label by default
  LabelArray(const LabelArray &la);
  
  ~LabelArray();			// destructor -- make sure label deleted

  void SetLabel(const char *newlabel);	// assign the label to the point
  const char *Label() const;			  // accessor function returning label

  const LabelArray &operator=(const LabelArray &a);

  // define << operator as friend function to LabelArray
  friend std::ostream& operator<<(std::ostream& os, const LabelArray &la);
};

