//
// Demonstration program to show the use of class hierarchys in C++
// Donald H. House  Jan. 31, 1995
// Visualization Lab, Texas A&M University
//

#include <iostream>
#include <cstring>

#include "labelpoint.h"

using namespace std;

labelpoint::labelpoint(int x0, int y0, char *initlabel){
  set(x0, y0);
  label = NULL;
  setlabel(initlabel);
}

labelpoint::~labelpoint(){
  delete label;
}

void labelpoint::setlabel(char *newlabel){
  delete label;		  // if old label, make sure it's space is freed
  
  if(newlabel == NULL)
    label = NULL;
  else{
    label = new char[strlen(newlabel) + 1];
    strcpy(label, newlabel);
  }
}

char * labelpoint::getlabel(){
  char *str;
  
  if(label == NULL)
    str = NULL;
  else{
    char * str = new char[strlen(label) + 1];
    strcpy(str, label);
  }
  
  return str;
}

ostream& operator<<(ostream& out, const labelpoint &p){
  if(p.label == NULL)
    return (out << "(" << p.x << ", " << p.y << ") -- <no label>");
  else
    return (out << "(" << p.x << ", " << p.y << ") -- " << p.label);
}
