//
// labelpoint class
// labelpoint.h
//
// Demonstration to show the use of class hierarchys in C++
// Donald H. House  March 29. 2005
// Visualization Lab, Texas A&M University
//

#include <iostream>
#include <cstring>

#include "point.h"

using namespace std;

//
// Subclass of 2D integer valued points with a text label
//
class labelpoint: public point{
protected:
  char * label;				// text label for point
  
public:
  labelpoint(int x0 = 0, int y0 = 0, char *initlabel = NULL);   // constuctor -- no label by default
  ~labelpoint();			// destructor -- make sure label deleted

  void setlabel(char *newlabel);	// assign the label to the point
  char * getlabel();			// accessor function for label

  // define << operator as friend function to labelpoint
  friend ostream& operator<<(ostream& out, const labelpoint &p);
};

