//
// point class
// point.cpp implementation file
//
// Donald H. House  March 29, 2005
// Visualization Lab, Texas A&M University
//

#include <iostream>
#include "point.h"

using namespace std;

point::point(int x0, int y0){
  set(x0, y0);
}

void point::set(int newx, int newy){
  x = newx;
  y = newy;
}

void point::translate(int dx, int dy){
  x += dx;
  y += dy;
}

point point::operator+(const point &p2){
  point sum;

  sum.set(x + p2.x, y + p2.y);

  return sum;
}

ostream& operator<<(ostream& out, const point &p){
  return(out << "(" << p.x << ", " << p.y << ")");
}

