//
// point class
// point.h header file
//
// Donald H. House  March 29, 2005
// Visualization Lab, Texas A&M University
//

#include <iostream>

using namespace std;

//
// Class of 2D integer valued points
//
class point{
protected:
  int x, y;				// x and y coordinates of point

public:
  point(int x0 = 0, int y0 = 0);	// default + initialize constructors

  void set(int newx, int newy);		// assign coordinates to point
  void translate(int dx, int dy);	// translate point by (dx, dy)

  int getx(){return x;}			// accessor function for x coord
  int gety(){return y;}			// accessor function for y coord

  // overload + operator to return sum of this point and p2
  point operator+(const point &p2);

  // define << operator as friend function to point
  friend ostream& operator<<(ostream& out, const point &p);
};


