/*
   queue.c

   Definitions of functions for maintaining
   a queue using a list-based approach
  
   D.H. House, Oct. 8, 2019
   CPSC 1070, Clemson University
*/

#include <stdio.h>
#include <stdlib.h>
#include "queue.h"

void clear(Queue *q){
  q->head = q->tail = NULL;
}

int empty(Queue *q){
  return q->head == NULL;
}

void enter(int num, Queue *q){
  Node *newnode = (Node *)malloc(sizeof(Node));
  newnode->value = num;
  newnode->next = NULL;

  if(q->tail == NULL)
    q->head = newnode;
  else
    q->tail->next = newnode;

  q->tail = newnode;
}

int leave(Queue *q){
  Node *firstnode = q->head;
  int n = firstnode->value;
  
  q->head = firstnode->next;

  if(q->head == NULL)
    q->tail = NULL;
  
  free(firstnode);
  
  return n;
}
