/*
   stack.c

   Definitions of functions for maintaining
   a stack using a list-based approach
  
   D.H. House, Oct. 8, 2019
   CPSC 1070, Clemson University
*/

#include <stdio.h>
#include <stdlib.h>
#include "stack.h"

void clear(Stack *s){
  s->top = NULL;
}

int empty(Stack *s){
  return s->top == NULL;
}

void push(int num, Stack *s){
  Node *newnode = (Node *)malloc(sizeof(Node));
  newnode->value = num;
  newnode->next = s->top;
  s->top = newnode;
}

int pop(Stack *s){
  Node *topnode = s->top;
  int n = topnode->value;
  
  s->top = topnode->next;
  free(topnode);
  
  return n;
}
