//
//  looppal.c
//  implementation of palindrome test using a loop
//  also showing string processing and command line argument
//  This version uses array indices
//
//  Donald House 9/3/19.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef enum _bool{FALSE, TRUE} bool;

// loop to do the palindrome beginning with the start and end string indices
bool ispalindrome(char str[]){
  int first = 0;
  int last = strlen(str) - 1;
  
  while(first < last && str[first] == str[last]){
    first++;
    last--;
  }

  return first >= last;
}

// program takes one command line argument, which is the string to test
int main(int argc, char *argv[]){
  if(argc != 2){
    printf("usage: palindrome <string>\n");
    exit(1);
  }
  
  if(ispalindrome(argv[1]))
    printf("%s is a palindrome\n", argv[1]);
  else
    printf("%s is not a palindrome\n", argv[1]);

  return 0;
}
