//
//  palindrome.c
//  recursive implementation of palindrome test
//  also showing string processing and command line argument
//  This version uses array indices
//
//  Donald House 9/3/19.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef enum _bool{FALSE, TRUE} bool;

// recursive palindrome test given first and last indices of substring to test
bool rpalindrome(char str[], int first, int last){
  if(last - first <= 0)
    return TRUE;
  else if(str[first] != str[last])
    return FALSE;
  else
    return rpalindrome(str, first + 1, last - 1);
}

// get the recursive palindrome test by supplying start and end string indices
bool ispalindrome(char str[]){
  return rpalindrome(str, 0, strlen(str) - 1);
}

// program takes one command line argument, which is the string to test
int main(int argc, char *argv[]){
  if(argc != 2){
    printf("usage: palindrome <string>\n");
    return 1;
  }
  
  if(ispalindrome(argv[1]))
    printf("%s is a palindrome\n", argv[1]);
  else
    printf("%s is not a palindrome\n", argv[1]);

  return 0;
}
