//
//  ptrpal.c
//  recursive implementation of palindrome test
//  also showing string processing and command line argument
//  This version uses pointers instead of string indices
//
//  Donald House 9/3/19.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef enum _bool{FALSE, TRUE} bool;

// recursive palindrome test given pointers to first and last character
// of substring being tested
bool rpalindrome(char *firstchar, char *lastchar){
  if(firstchar >= lastchar)   // here we check the memory locations of first and last
    return TRUE;
  else if(*firstchar != *lastchar) // here we check to see if the chars are equal
    return FALSE;
  else
    return rpalindrome(firstchar + 1, lastchar - 1); // recursive test of substring
}

// start the recursive palindrome test by supplying pointers to the beginning
// and end of the character string being tested
bool ispalindrome(char str[]){
  return rpalindrome(str, str + strlen(str) - 1);
}

// program takes one command line argument, which is the string to test
int main(int argc, char *argv[]){
  if(argc != 2){
    printf("usage: ptrpal <string>\n");
    exit(1);
  }
  
  if(ispalindrome(argv[1]))
    printf("%s is a palindrome\n", argv[1]);
  else
    printf("%s is not a palindrome\n", argv[1]);

  return 0;
}
