//
// compact-isright.c
//
// Read the lengths of the 3 sides of a triangle determine
// if it is a right triangle.
// This version uses a more dense C coding style
//
// D.H. House, Sept. 2, 2019
//

#include <stdio.h>
#include <math.h>

const float eps = 0.001;

int almostequal(float a, float b){
  return fabs(a - b) < eps;
}

void swap(float *a, float *b){
  float temp;
  temp = *a;
  *a = *b;
  *b = temp;
}

float hypotenuse(float sidea, float sideb){
  return sqrt(sidea * sidea + sideb * sideb);
}

int isrighttri(float sidea, float sideb, float sidec){
  if(sidea > sideb)
    swap(&sidea, &sideb);
  if(sideb > sidec)
    swap(&sideb, &sidec);
  
  return almostequal(sidec, hypotenuse(sidea, sideb));
}

int main(){
  float sidea, sideb, sidec;
  
  printf("enter 3 sides: ");
  scanf("%f %f %f", &sidea, &sideb, &sidec);

  if(isrighttri(sidea, sideb, sidec))
    printf("is a right triangle\n");
  else
    printf("not a right triangle\n");
}
