//
// Read the lengths of the 3 sides of a triangle determine
// if it is a right triangle
// D.H. House, Sept. 2, 2019
//

#include <stdio.h>
#include <math.h>

const float eps = 0.001;

int almostequal(float a, float b){
  return fabs(a - b) < eps;
}

void swap(float *a, float *b){
  float temp;
  temp = *a;
  *a = *b;
  *b = temp;
}

float hypotenuse(float sidea, float sideb){
  float hypot;
  
  hypot = sqrt(sidea * sidea + sideb * sideb);
  return hypot;
}

int isrighttri(float sidea, float sideb, float sidec){
  float hypot;
  
  if(sidea > sideb)
    swap(&sidea, &sideb);
  if(sideb > sidec)
    swap(&sideb, &sidec);
  hypot = hypotenuse(sidea, sideb);
  
  return almostequal(sidec, hypot);
}

int main(){
  float sidea, sideb, sidec;
  int isright;
  
  printf("enter 3 sides: ");
  scanf("%f %f %f", &sidea, &sideb, &sidec);

  isright = isrighttri(sidea, sideb, sidec);
  
  if(isright)
    printf("is a right triangle\n");
  else
    printf("not a right triangle\n");
}
