/*
 rainbow.c
 EZ Draw Program to Draw a Rainbow. 2D array demonstration
 
 CPSC 1070         Donald H. House         2/9/2019
 Clemson University
*/

#include "ezdraw.h"

// Window Dimensions
#define WIDTH	        800
#define HEIGHT		    600

#define X0			      (WIDTH / 2)
#define GROUND			  (HEIGHT / 5)
#define RADIUS		    (HEIGHT / 3)

#define BACKCOLOR     50, 50, 100
#define GROUNDCOLOR   150, 80, 50

enum bool{FALSE, TRUE};

//
// Draw a rainbow as a set of circles of increasing radius
//
void drawRainbow(int xc, int yc, int radius){
  int c[6][3] = {{127, 0, 255}, {0, 0, 255}, {0, 255, 0},
                 {255, 255, 0}, {255, 127, 0}, {255, 0, 0}};
  int color;
  int i;
  
  for(color = 0; color < 6; color++){
    EZ_SetColor(c[color][0], c[color][1], c[color][2]);
    for(i = 0; i < 10; i++)
      EZ_OutlineCircle(xc, yc, radius++);
  }
}

/*
 Display callback routine: clear the screen and draw the rainbow
 This is called every 1/30 of a second
*/
void drawDisplay(){
  
  /* clear the drawing to the background color */
  EZ_SetBackColor(BACKCOLOR);
  EZ_ClearDrawing();
  
  /* draw the rainbow as a set of circles */
  drawRainbow(X0, GROUND, RADIUS);
  
  // draw the ground to cover the bottom of the rainbow
  EZ_SetColor(GROUNDCOLOR);
  EZ_FillRect(0, 0, WIDTH, GROUND);
  EZ_DisplayDrawing();
}

/*
  Main program to draw a rainbow and then wait for quit
*/
int main(){
  enum bool quit = FALSE;
  
  /* start up the glut utilities */
  EZ_Init(WIDTH, HEIGHT, "Rainbow Demonstration");
  
  while(!quit){
    quit = EZ_HandleEvents(drawDisplay, NULL, NULL, NULL);
  }
  
  EZ_Quit();
  return 0;
}
