#include <iostream>
#include <cstring>

class string {
public:
  string(const char* b) : buf(new char[strlen(b)+1]) {
    strcpy(buf, b);
  }
  string(const string& s) : buf(new char[strlen(s.buf)+1]) {
    strcpy(buf, s.buf);
  }
  ~string() { 
    delete [] buf; 
  }
  string& operator=(const string& rhs) {
    if (this == &rhs) return * this;
    delete [] buf;
    buf = new char[strlen(rhs.buf)+1];
    strcpy(buf, rhs.buf);
    return *this;
  }

  const char* getBuf() const { return buf; }

private:
  char* buf;
};

std::ostream& operator<<(std::ostream& out, const string& s) {
  return out << s.getBuf();
}

int main() {
  string x("antelope"), y(x);
  std::cout << x << std::endl;
  std::cout << y << std::endl;
  string* leak = new string("leak");
  delete leak;
}
