#include "hud.h"

Hud::Hud() : 
  width( Gamedata::getInstance().getXmlInt("hud/width") ), 
  height( Gamedata::getInstance().getXmlInt("hud/height") ), 
  drawHud( Gamedata::getInstance().getXmlBool("hud/showAtStart") ),
  pos(
    Gamedata::getInstance().getXmlInt("hud/x"), 
    Gamedata::getInstance().getXmlInt("hud/y") 
  ),
  io( IOManager::getInstance() ),
  screen( io.getScreen() ),
  clock( Clock::getInstance() ),
  viewport( Viewport::getInstance() ),
  RED( SDL_MapRGB(screen->format, 0xff, 0, 0) )
{}

void Hud::draw() const {
  if ( !drawHud ) return;
  Draw_AALine(screen, pos[0], pos[1]+height/2, 
                      pos[0]+width,pos[1]+height/2, 
                      height, 0xff, 0xff, 0xff, 0xff/2);
  Draw_AALine(screen, pos[0], pos[1], 
                      pos[0]+width,pos[1], 1.0f, RED);
  Draw_AALine(screen, pos[0], pos[1]+height, 
                      pos[0]+width,pos[1]+height, 1.0f, RED);
  Draw_AALine(screen, pos[0], pos[1], 
                      pos[0],pos[1]+height, 2.0f, RED);
  Draw_AALine(screen, pos[0]+width, pos[1], 
                      pos[0]+width,pos[1]+height, 2.0f, RED);

  io.printMessageValueAt("Seconds: ",
    clock.getSeconds(), pos[0]+10, pos[1]+10);
  io.printMessageValueAt("fps: ", clock.getFps(), pos[0]+10, pos[1]+30);
  io.printMessageAt("Press T to switch sprites", pos[0]+10, pos[1]+50);

  io.printMessageAt("F1 toggles this HUD ", pos[0]+10, pos[1]+110);
  io.printMessageAt("F2 toggles bullet pool  ", pos[0]+10, pos[1]+130);
  io.printMessageAt("F3 toggles Score Board  ", pos[0]+10, pos[1]+150);
  io.printMessageAt("F4 toggles Slo-mo  ", pos[0]+10, pos[1]+170);
  io.printMessageAt("F5 toggles god mode  ", pos[0]+10, pos[1]+190);
  io.printMessageAt("p to pause  ", pos[0]+10, pos[1]+220);
  io.printMessageAt("r to restart  ", pos[0]+10, pos[1]+240);
  io.printMessageAt("space/left-mouse to shoot  ", pos[0]+10, pos[1]+270);
  io.printMessageAt("asdw moves Pter  ", pos[0]+10, pos[1]+290);
  viewport.draw();
}
