//
// Circle class, subclass of Shape
// Circle.cpp
//
// Demonstration to show the use of class hierarchys in C++\
//
// Donald H. House  Nov. 19, 2019
// CPSC 1070 example code
// Clemson University
//

#include "Circle.h"
using namespace std;

Circle::Circle(){
  radius = 0;
}

void Circle::SetRadius(int r){
  radius = r;
}

int Circle::GetRadius() const{
  return radius;
}

void Circle::Draw() const{
  if(filled)
    EZ_FillCircle(position.x, position.y, radius);
  else
    EZ_OutlineCircle(position.x, position.y, radius);
}

ostream& operator<<(ostream &os, const Circle &c){
  return(os << "(" << c.position.x << ", " << c.position.y << "): " << c.radius << ": " << c.filled);
}
