//
// Circle class, subclass of Shape
// Circle.h
//
// Demonstration to show the use of class hierarchies in C++
//
// Donald H. House  Nov. 19, 2019
// CPSC 1070 example code
// Clemson University
//

#ifndef _CIRCLE_H_
#define _CIRCLE_H_

#include "Shape.h"
#include <iostream>

//
// Subclass of 2D integer valued points with a text label
//
class Circle: public Shape{
private:
  int radius;
  
public:
  Circle();

  void SetRadius(int r);
  int GetRadius() const;
  
  virtual void Draw() const;

  // define << operator as friend function to Circle
  friend std::ostream& operator<<(std::ostream& os, const Circle &c);
};

#endif
