//
// Shape class
// Shape.cpp definition file
//
// Donald H. House  Nov. 19, 2019
// CPSC 1070 example code
// Clemson University
//

#include "Shape.h"
using namespace std;

Shape::Shape(): filled(false){
  position.x = 0;
  position.y = 0;
}

void Shape::SetPosition(const EZ_Point &p){
  position = p;
}

EZ_Point Shape::GetPosition() const{
  return position;
}

void Shape::SetFill(bool fill){
  filled = fill;
}
bool Shape::GetFill() const{
  return filled;
}

void Shape::Translate(int dx, int dy){
  position.x += dx;
  position.y += dy;
}

Shape Shape::operator+(const EZ_Point &p2) const{
  Shape sum;
  
  EZ_Point p;
  p.x = position.x + p2.x;
  p.y = position.y + p2.y;
  sum.SetPosition(p);

  return sum;
}

void Shape::Draw() const{
  EZ_DrawPoint(position.x, position.y);
}

ostream& operator<<(ostream& os, const Shape &s){
  return(os << "(" << s.position.x << ", " << s.position.y << "): " << s.filled);
}

