//
// Shape class
// Shape.h header file
//
// Donald H. House  Nov. 19, 2019
// CPSC 1070 example code
// Clemson University
//

#ifndef _SHAPE_H_
#define _SHAPE_H_

#include "ezdraw.h"
#include <iostream>

//
// Class of 2D shapes that can be drawn using EZ Draw
//
class Shape{
protected:
  EZ_Point position;				// x and y coordinates of shape
  bool filled;

public:
  Shape();

  void SetPosition(const EZ_Point &p);		// assign coordinates to point
  EZ_Point GetPosition() const;
  
  void SetFill(bool fill);
  bool GetFill() const;
  
  void Translate(int dx, int dy);	// translate shape by (dx, dy)

  // overload + operator to translate this Shape by p2
  Shape operator+(const EZ_Point &p2) const;
  
  virtual void Draw() const;

  // define << operator as friend function to Shape
  friend std::ostream& operator<<(std::ostream& os, const Shape &s);
};

#endif

