//
// Triangle class, subclass of Shape
// Triangle.cpp
//
// Demonstration to show the use of class hierarchys in C++
//
// Donald H. House  Nov. 19, 2019
// CPSC 1070 example code
// Clemson University
//

#include "Triangle.h"
using namespace std;

Triangle::Triangle(){
  for(int i = 0; i < 3; i++){
    verts[i].x = 0;
    verts[i].y = 0;
  }
}

void Triangle::SetVerts(const EZ_Point v[3]){
  for(int i = 0; i < 3; i++)
    verts[i] = v[i];
}

void Triangle::GetVerts(EZ_Point v[3]) const{
  for(int i = 0; i < 3; i++)
    v[i] = verts[i];
}

void Triangle::Draw() const{
  EZ_Point p[3];
  for(int i = 0; i < 3; i++){
    p[i].x = position.x + verts[i].x;
    p[i].y = position.y + verts[i].y;
  }
    
  if(filled)
    EZ_FillTriangle(p[0], p[1], p[2]);
  else
    EZ_OutlineTriangle(p[0], p[1], p[2]);
}

ostream& operator<<(ostream &os, const Triangle &t){
  os << "(" << t.position.x << ", " << t.position.y << "): " << t.filled << ": {";
  for(int i = 0; i < 2; i++)
    os << "[" << t.verts[i].x << ", " << t.verts[i].y << "], ";
  os << "[" << t.verts[2].x << ", " << t.verts[2].y << "]}";
  return os;
}
